<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class PointsOfOriginModel extends CI_Model {
	    
#TODO - This method should be refactored to use Active Record, including the limit() functionality.  We should not need to run preg_matches to remove things that we add in this message.		
    function get_message_counts_grouped_by_application($application_id = null, $between = null, $order, $dir, $destination_page, $items_per_page, $is_export) {

    	$sql_points_of_origin = '';
    	$select_from_points_of_origin = ' application_name, message_count ';
    	if(!$is_export) {
    		$select_from_points_of_origin = ' * ';
    	}
    	
    	if(isset($application_id) && isset($order) && isset($dir)) {
    		$sql_points_of_origin = 'select ' . $select_from_points_of_origin . ' from (select ROW_NUMBER() over (order by ' . $order . ' ' . $dir .') as row, * ';
    	}
    	else {
    		$sql_points_of_origin = 'select ' . $select_from_points_of_origin . ' from (select ROW_NUMBER() over (order by application_name asc) as row, * ';
    	}
    	

    	$sql_points_of_origin .= 'from (select COUNT(r.id) message_count, a.name application_name, a.id application_id from request r, application a '. 
    								'where r.application_id = a.id and upper(r.call) like upper(\'%send%\') '. 
    								'and r.response_code = 200 ';

    	if($between != null) {
    		foreach ($between as $key => $value){//this if for anything that has an upper and lower boundary (ie date)
    			if($value['end']){
    				$sql_points_of_origin .= "AND (r.". $key ." <= ".$this->db->escape($value['end']).") ";
    			}
    			if($value['start']){
    				$sql_points_of_origin .= "AND (r.". $key ." >= ".$this->db->escape($value['start']). ")";
    			}
    		}
    	}
    	
    	$sql_points_of_origin .= ' group by a.name, a.id) as temp) as points_of_origin ' .
    							 ' where 1 = 1 ';
    	if($application_id != '(ALL)' && $application_id != null) {
	    		$sql_points_of_origin .= ' and application_id = ' . $application_id;
	    	}
	    	
    	//sql query that excludes the date filter to include users who had no acitivity during the time period specified
    	$sql_date_filter_excluded = preg_replace('/AND \(r.call_date \<\= [0-9]{10}\)/' , '' , $sql_points_of_origin);
    	$sql_date_filter_excluded = preg_replace('/AND \(r.call_date \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
	    	
	    $total_size = sizeof($this->db->query($sql_points_of_origin)->result());
    	if(!$is_export) {
	    	$start = ($destination_page - 1) * $items_per_page + 1;
	    	if($start > $total_size) {
	    		$start = 1;
	    	}
	    	$sql_points_of_origin .= ' and row >= '.$this->db->escape($start).' and row < '.$this->db->escape($start+$items_per_page);
    	}
    	else {
    		$sql_points_of_origin .= ' and row >= 1 ' ;
    	}
    	
    	//sql query that excludes the date filter to include users who had no acitivity during the time period specified
    	$sql_date_filter_excluded = preg_replace('/AND \(r.call_date \<\= [0-9]{10}\)/' , '' , $sql_points_of_origin);
    	$sql_date_filter_excluded = preg_replace('/AND \(r.call_date \>\= [0-9]{10}\)/' , '' , $sql_date_filter_excluded);
    		
    	$responses = $this->db->query($sql_points_of_origin)->result();
    	$new_responses = [];
    	foreach($responses as $poo) {
    		$new_responses[$poo->application_name] = $poo;
    	}
    	
    	$responses_date_filter_excluded = $this->db->query($sql_date_filter_excluded)->result();
    	//include the users who had no acitivty in the time period specified
    	$complete_responses = [];
    	foreach($responses_date_filter_excluded as $poo) {
    		if(!key_exists($poo->application_name, $new_responses)) {
    			$poo->message_count = 0;
    			$complete_responses[$poo->application_name] = $poo;
    		}
    		else {
    			$complete_responses[$poo->application_name] = $new_responses[$poo->application_name];
    		}
    	}
    	
    	return array('total_size'=>$total_size, 'list'=>$complete_responses);
    }
    
    
}